/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */


/**************************************************
    Entorno de Desarrollo Modular y Abierto
    EDMA 0.2r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF WIzard Tcl/Tk 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : EDMAIDF_PARSER
    Description : Parser for EDMAIDF Files
    Author      : David Martnez Oliveira
    Date        : July 27th 1999
-----------------------------------------------------
  REVISIONS :
***************************************************/
 
 
#include <stdio.h>
#include <string.h>
#include "portable.h"
#include <edma.h>

/* Data structs for class EDMAIDF_PARSER*/
  
typedef struct
  {
    EPChar	FileName;
    PINIFILE	h;
  } DtEDMAIDF_PARSER;
 
ESint32  EDMAPROC 
EDMAIDF_PARSERGetNPropsU32 (OBJID IdObj,EPUint32 n)
{
  DtEDMAIDF_PARSER	*m;
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  /* Put your code here */
  *n=edma_get_ini_int(m->h,"Definition","PropertiesNum",0);
  edma_printf_obj(IdObj,"[Definition]PropertiesNum=%d",*n);
  return 0;
}

ESint32  EDMAPROC 
EDMAIDF_PARSERGetNMetsU32 (OBJID IdObj,EPUint32 n)
{
  DtEDMAIDF_PARSER	*m;
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  *n=edma_get_ini_int(m->h,"Definition","MethodsNum",0); 
  edma_printf_obj(IdObj,"[Definition]MethodsNum=%d",*n);
  return 0;
}
 
ESint32  EDMAPROC 
EDMAIDF_PARSERGetClassNamesZ (OBJID IdObj,EPChar buf)
{
  DtEDMAIDF_PARSER	*m;
  EUint32                 r;
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  r=edma_get_ini_string (m->h,"General","Name",NULL,buf,200);
  edma_printf_obj(IdObj,"[General]Name=%s",buf);
  return 0;
}

ESint32  EDMAPROC 
EDMAIDF_PARSERGetModuleNamesZ (OBJID IdObj,EPChar buf)
{
  DtEDMAIDF_PARSER	*m;
  EUint32                 r;
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  r=edma_get_ini_string(m->h,"SYS_DEF","ModuleName",NULL,buf,200);
  edma_printf_obj(IdObj,"[SYS_DEF]ModuleName=%s",buf);
  return 0;
}

ESint32  EDMAPROC 
EDMAIDF_PARSERGetNameSpacesZ (OBJID IdObj,EPChar buf)
{
  DtEDMAIDF_PARSER	*m;
  EUint32                 r;
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  r=edma_get_ini_string(m->h,"SYS_DEF","NameSpace",NULL,buf,200);
  edma_printf_obj(IdObj,"[SYS_DEF]NameSpace=%s",buf);
  return 0;
}



ESint32  EDMAPROC 
EDMAIDF_PARSERGetSCListsZ (OBJID IdObj,EPChar buf)
{
  DtEDMAIDF_PARSER	*m;
  EUint32                 r;
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  r=edma_get_ini_string(m->h,"Definition","SCList",NULL,buf,200);
  edma_printf_obj(IdObj,"[Definition]SCList=%s",buf); 
  return 0;
}

ESint32  EDMAPROC 
EDMAIDF_PARSERGetPropNameU32sZ (OBJID IdObj,EUint32 n,EPChar buf)
{
  DtEDMAIDF_PARSER	*m;
  EChar                   Sec[80];
  EUint32                 r;
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
 
  sprintf (Sec,"Prop%ld",n);
  r=edma_get_ini_string(m->h,Sec,"Name",NULL,buf,200);
  edma_printf_obj(IdObj,"[%s]Name=%s",Sec,buf);
  
  return 0;
}

ESint32  EDMAPROC 
EDMAIDF_PARSERGetPropTypeU32sZ (OBJID IdObj,EUint32 n,EPChar buf)
{
  DtEDMAIDF_PARSER	*m;
  EChar                   Sec[80];
  EUint32                 r;
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  sprintf (Sec,"Prop%ld",n);
  r=edma_get_ini_string(m->h,Sec,"Type",NULL,buf,200);
  edma_printf_obj(IdObj,"[%s]Type=%s",Sec,buf); 
  return 0;
}

ESint32  EDMAPROC 
EDMAIDF_PARSERGetPropAccessU32sZ (OBJID IdObj,EUint32 n,EPChar buf)
{
  DtEDMAIDF_PARSER	*m;
  EChar                   Sec[80];
  EUint32                 r;
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  sprintf (Sec,"Prop%ld",n);
  r=edma_get_ini_string(m->h,Sec,"Access",NULL,buf,200);
  edma_printf_obj(IdObj,"[%s]Access=%s",Sec,buf);  
  return 0;
}

ESint32  EDMAPROC 
EDMAIDF_PARSERGetPropNElemsU32sU32 (OBJID IdObj,EUint32 n,EPUint32 ne)
{
  DtEDMAIDF_PARSER	*m;
  EChar                   Sec[80];
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  sprintf (Sec,"Prop%ld",n);
  *ne=edma_get_ini_int(m->h,Sec,"ArrayElems",0);
  edma_printf_obj(IdObj,"[%s]ArrayElems=%d",Sec,*ne); 
  return 0;
}

ESint32  EDMAPROC 
EDMAIDF_PARSERGetMetNameU32sZ (OBJID IdObj,EUint32 n,EPChar buf)
{
  DtEDMAIDF_PARSER	*m;
  EChar                   Sec[80];
  EUint32                 r;
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  sprintf (Sec,"Met%ld",n);
  r=edma_get_ini_string(m->h,Sec,"Name",NULL,buf,200);
  edma_printf_obj(IdObj,"[%s]Name=%s",Sec,buf);  
  
  return 0;
}

ESint32  EDMAPROC 
EDMAIDF_PARSERGetMetSignatureU32sZ (OBJID IdObj,EUint32 n,EPChar buf)
{
  DtEDMAIDF_PARSER	*m;
  EChar                   Sec[80];
  EUint32                 r;
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  sprintf (Sec,"Met%ld",n);
  r=edma_get_ini_string(m->h,Sec,"Signature",NULL,buf,200);
  edma_printf_obj(IdObj,"[%s]Signature=%s",Sec,buf);  
  return 0;
}

ESint32  EDMAPROC 
EDMAIDF_PARSERIsMetVirtualU32sU32 (OBJID IdObj,EUint32 n,EPUint32 ne)
{
  DtEDMAIDF_PARSER	*m;
  EChar                   Sec[80];
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  sprintf (Sec,"Met%ld",n);
  *ne=edma_get_ini_int(m->h,Sec,"Virtual",0);
  edma_printf_obj(IdObj,"[%s]Virtual=%d",Sec,*ne);  
  return 0;
}

ESint32  EDMAPROC 
EDMAIDF_PARSERIsMetAbstractU32sU32 (OBJID IdObj,EUint32 n,EPUint32 ne)
{
  DtEDMAIDF_PARSER	*m;
  EChar                   Sec[80];
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  sprintf (Sec,"Met%ld",n);
  *ne=edma_get_ini_int(m->h,Sec,"Abstract",0);
  edma_printf_obj(IdObj,"[%s]Abstract=%d",Sec,*ne);  
  return 0;
}

ESint32  EDMAPROC 
EDMAIDF_PARSERIsMetStaticU32sU32 (OBJID IdObj,EUint32 n,EPUint32 ne)
{
  DtEDMAIDF_PARSER	*m;
  EChar                   Sec[80];
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  sprintf (Sec,"Met%ld",n);
  *ne=edma_get_ini_int(m->h,Sec,"Static",0);
  edma_printf_obj(IdObj,"[%s]Static=%d",Sec,*ne);  
  return 0;
}

ESint32  EDMAPROC 
EDMAIDF_PARSEROpenZ (OBJID IdObj,EPChar name)
{
  DtEDMAIDF_PARSER	*m;
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  m->h=edma_open_ini (name); 
  return 0;
}
 
ESint32  EDMAPROC 
EDMAIDF_PARSERClose(OBJID IdObj)
{
  DtEDMAIDF_PARSER	*m;
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  
  edma_close_ini (m->h);
  return 0;
}

ESint32 EDMAPROC
EDMAIDF_PARSERGetMajorVersionsS32rS32 (OBJID IdObj, ESint32 *v)
{
  DtEDMAIDF_PARSER	*m;
  
  m = (DtEDMAIDF_PARSER*) edma_get_data_ref (IdObj);
  *v = edma_get_ini_int (m->h, "SYS_DEF", "MajorVer", 0); 
  return *v;
}
 
ESint32 EDMAPROC
EDMAIDF_PARSERGetMinorVersionsS32rS32 (OBJID IdObj, ESint32 *v)
{
  DtEDMAIDF_PARSER	*m;
  
  m=(DtEDMAIDF_PARSER*)edma_get_data_ref(IdObj);
  *v = edma_get_ini_int (m->h, "SYS_DEF", "MinorVer", 0); 
  return *v;

}
