# This example does a planetary orbit simulation, with two suns situated at
# (0,0) and (-5,0) and one planet starting out at (1,0).  You may run it by
# typing

#    ode -f orbit.x | graph-X -C -y -1 3 -x -6 2
#    step 0,10
#    step 10,20
#    step 20,30
#    step 30,40
#    step 40,50
#    step 50,60
#    .

# The planet's orbit will be traced out incrementally.  If you are using a
# color X Windows display, each segment of the orbit will be a different
# color.  This is a feature provided by graph-X, which normally changes the
# linemode after each dataset it reads. If you do not like this feature,
# you may turn it off by using `graph-X -B' instead of `graph-X'.

# x and y are positions
# vx and vy are velocities

vx' = -x/((x^2+y^2)^(3/2)) -(x+5)/(((x+5)^2+y^2)^(3/2))
vy' = -y/((x^2+y^2)^(3/2)) -y/(((x+5)^2+y^2)^(3/2))
y' = vy
x' = vx

x = 1
y = 0

print x,y every 5

# these values seem to give a nice orbit:
# vx = 0
# vy = 1.142

# a more exciting result can be obtained from:
vx = 0
vy = 1.165

#step 0,20
