/* Source Installer, Copyright (c) 2005 Claudio Fontana

   srcspawn.h - process spawning and logging

   This program is free software; you can redistribute it and/or modify
       it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
       (at your option) any later version.

   This program is distributed in the hope that it will be useful,
       but WITHOUT ANY WARRANTY; without even the implied warranty of
       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
       GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
       along with this program (look for the file called COPYING);
       if not, write to the Free Software Foundation, Inc.,
           51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

       You can contact the author (Claudio Fontana) by sending a mail
       to claudio@gnu.org
*/

#ifndef SRCSPAWN_H
#define SRCSPAWN_H

typedef void* SRCINST_SPAWN_ID;

/* access spawned process information */
int srcinst_get_spawn_in(SRCINST_SPAWN_ID id);
int srcinst_get_spawn_out(SRCINST_SPAWN_ID id);
int srcinst_get_spawn_err(SRCINST_SPAWN_ID id);
pid_t srcinst_get_spawn_pid(SRCINST_SPAWN_ID id);

/* basic spawning system: spawn, then wait. */
SRCINST_SPAWN_ID srcinst_spawn(char* args, ...);
int srcinst_wait(SRCINST_SPAWN_ID id);

/* abstractions on the base spawning system: */

/* spawn, wait, and check for return error. Returns 1=ok, 0=err.
   Last argument a zero please. */
int srcinst_spawn_wait(char* args, ...);

/* same thing, vector version. Terminate with a 0 please. */
int srcinst_spawn_waitve(char* argz, char** args);

/* like before, but match PATTERN in the output, and return first
   subpattern (in heap). */
char* srcinst_spawn_wait_expect(char* pattern, char* args, ...);

/* this time spawn, wait, check for error, and return ALL the output as
   a single heap allocated string. */
char* srcinst_spawn_wait_expect_all(char* args, ...);

/* like before, but return all the output divided per lines in a filled out
   string list */
int srcinst_spawn_wait_expect_lines(struct srcinst_string_list* list, char* args, ...);

/* another variation. In this case we build a list with the output only for the lines that contain PAT, which is stripped from the output. */
int srcinst_spawn_wait_expect_strip(char* pat, struct srcinst_string_list* l, char* args, ...);

/* int srcinst_spawn_wait_sudo(char* user, char* pass, char* args, ...); */

#endif /* SRCINST_SPAWN_H */
