/* Source Installer, Copyright (c) 2005 Claudio Fontana

 srccallback.c - simple callbacks

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/


#include "src_stdinc.h"

void _init_callback_list(struct _callback_list* list) {
  list->count = 0;
  list->first = 0;
}

void _add_callback_list(struct _callback_list* list, srcinst_callback callback) {
  struct _callback_node* tmp;
  tmp = list->first;
  list->first = srcinst_malloc(sizeof(struct _callback_node));
  list->first->next = tmp;
  list->first->callback = callback;
  list->count++;
}

void _remove_callback_list(struct _callback_list* list, srcinst_callback callback) {
  struct _callback_node* this, *tmp;
  
  if (!(this = list->first))
    return;

  while ((tmp = this->next)) {
    if (tmp->callback == callback) {
      this = this->next;
      free(tmp);
      list->count--;

    } else {
      this = this->next;
    }
  }

  if (list->first->callback == callback) {
    tmp = list->first;
    list->first = list->first->next;
    free(tmp);
    list->count--;
  }
}

void _fini_callback_list(struct _callback_list* list) {
  struct _callback_node* this, *tmp;
  
  if (!(this = list->first))
    return;

  while ((tmp = this->next)) {
    this = this->next;
    free(tmp);
  }

  free(list->first);
  list->first = 0;
  list->count = 0;
}
