%{
/*
 * java2html.cc
 *
 * java2html
 * generates html code from Java code
 * Copyright (C) 1999  Lorenzo Bettini, lorenzo.bettini@penteres.it
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */                         

#include <string.h>
#include <iostream.h>
#include <fstream.h>

#include "config.h"

#ifdef HAVE_STRSTREAM_H
#include <strstream.h>
#else
#ifdef HAVE_STRSTREA_H
#include <strstrea.h>
#endif // HAVE_STRSTREA_H
#endif // HAVE_STRSTREAM_H

#include "tags.h"
#include "colors.h"
#include "keys.h"
#include "messages.h"

static char buffer[ 256 ] ;

static int yyparse() ;
static int yylex() ;
static void yyerror( char *s ) ;
static istream *fin ;
static int line = 0 ;

void parseTags() ;

%}

%union {
  int tok ; /* command */
  char * string ; /* string : id, ... */
  int flag ;
  Tag *tag ;
  Tags *tags ; 
} ;

%token <flag> BOLD ITALICS UNDERLINE
%token <string> KEY COLOR 

%type <tag> option
%type <tags> options
%type <flag> values value

%%

globaltags : options { setTags( $1 ) ; }

options : options option { $1->AddTag( $2 ) ; }
        | option { $$ = new Tags() ; $$->AddTag( $1 ) ;  }
        ;

option : KEY COLOR 
             { 
                 printMessage( $1 ) ;
                 printMessage( $2 ) ;
             } 
         values ';' 
             { 
	       $$ = new Tag( strdup($1), strdup($2) ) ;
               $$->SetFlags($4) ; 
	     } 
       ;

values : values ',' value { $$ = $1 | $3 ; }
       | value
       ;

value : { $$ = 0 ; printMessage( " (no options) " ) ; }
      | BOLD { printMessage( " - bold" ) ; $$ = ISBOLD ; }
      | ITALICS { printMessage( " - italics" ) ; $$ = ISITALIC ; }
      | UNDERLINE { printMessage( " - underline" ) ; $$ = ISUNDERLINE ; }
      ;

%%

      /*
main() {
  yyparse() ;
}
      */

void parseTags() {
  fin = new ifstream( "tags.j2h" ) ;
  if ( ! *fin ) {
    printWarning( "No tags.j2h file, using defaults ...", cerr ) ;
    setTags( NULL ) ;
    return ;
  }

  printMessage( "Parsing tags.j2h file ...", cerr ) ;
  yyparse() ;
  printMessage( "Parsing done!", cerr ) ;
  
  delete fin ;
}

int yylex() {
  static short comma = 0 ;
  static short semicolon = 0 ;

  // if comma or ; are together with a letter, we've read it the previous
  // time, so we simply return it
  if ( comma ) {
    comma = 0 ;
    return ',' ;
  }

  if ( semicolon ) {
    semicolon = 0 ;
    ++line ;
    return ';' ;
  }

  (*fin) >> buffer ;

  if ( strchr( buffer, ',' ) && buffer[1] == ',' ) 
    comma = 1 ;

  if ( strchr( buffer, ';' ) && buffer[1] == ';' )
    semicolon = 1 ;

  if ( strlen( buffer ) == 1 || comma || semicolon ) {
    if ( buffer[0] == 'b' )
      return BOLD ;
    else if ( buffer[0] == 'i' )
      return ITALICS ;
    else if ( buffer[0] == 'u' )
      return UNDERLINE ;
    else if ( buffer[0] == ',' )
      return ',' ;
    else if ( buffer[0] == ';' ) {
      ++line ;
      return ';' ;
    }
  } else if ( strlen( buffer ) > 1 ) {
    if ( strcmp( buffer, KEYWORD ) == 0 ||
	 strcmp( buffer, TYPE ) == 0 ||
	 strcmp( buffer, STRING ) == 0 ||
	 strcmp( buffer, COMMENT ) == 0 ||
	 strcmp( buffer, NUMBER ) == 0 ) {
      yylval.string = strdup( buffer ) ;
      return KEY ;
    } else if ( strcmp( buffer, GREEN ) == 0 ||
		strcmp( buffer, RED ) == 0 ||
		strcmp( buffer, DARKRED ) == 0 ||
		strcmp( buffer, BLUE ) == 0 ||
		strcmp( buffer, BROWN ) == 0 ||
		strcmp( buffer, PINK ) == 0 ||
		strcmp( buffer, YELLOW ) == 0 ||
		strcmp( buffer, CYAN ) == 0 ||
		strcmp( buffer, PURPLE ) == 0 ||
		strcmp( buffer, ORANGE ) == 0 ||
		strcmp( buffer, BRIGHTORANGE ) == 0 ||
		strcmp( buffer, BRIGHTGREEN ) == 0 ||
		strcmp( buffer, BLACK ) == 0 ) 
      {
	yylval.string = strdup( buffer ) ;
	return COLOR ;
      }
  }
  return 0 ;
}

void yyerror( char *s ) {
  strstream str ;
  str << "*** " << s << " on option # " << line << ends ;
  printError( str.str(), cerr ) ;
  printError( "Using default tags...", cerr ) ;
}
