/* LocaleInformation_ko.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_ko extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|ITL|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIC|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|SUR|SUN|NCF|CVE|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|QAR|UAH|GNS|CNY|MZM|UYU|GNI|SML|MZE|PGK|OMS|GNF|UYP|OMR|XFU|ZRZ|BTR|MAF|MAD|XFO|BTN|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|DEM|NPR|CKD|JPY|MVR|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|GIP|VNS|VNR|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "\uc694\ub974\ub2e8 \ub514\ub098\ub974|\uae08|\ud398\ub85c\uc81c\ub3c4 \ud06c\ub85c\ub108|\ub808\ubc14\ub17c \ud30c\uc6b4\ub4dc|\uc720\ub85c\ud654|\ubca0\ud2b8\ub0a8 \ub3d9|\ud0c4\uc790\ub2c8\uc544 \uc2e4\ub9c1|\ubcfc\ub9ac\ube44\uc544\ub178 \ud398\uc18c|\uce84\ubcf4\ub514\uc544 \ub9ac\uc584|\uc544\uc2dc\uc544 \uae30\uae08 \uc5f0\ud569 \ud1b5\ud654 \ub2e8\uc704|\ubcfc\ub9ac\ube44\uc544\ub178 (1863-1962)|\uce84\ubcf4\ub514\uc544 \uad6c\uad8c \ub9ac\uc584|\uc7d8\ube44\uc544 \ud30c\uc6b4\ub4dc|\ud638\uc8fc \ud30c\uc6b4\ub4dc|\ubab0\ud0c0 \ud30c\uc6b4\ub4dc|\uac00\ub098 \uc7ac\ud3c9\uac00 \uc2dc\ub514|\uc7d8\ube44\uc544 \ucf70\uccd0|\uc544\uc2dc\uc544 \ub514\ub098\ub974 \uacc4\uc0b0 \ub2e8\uc704|\uac00\ub098 \ud30c\uc6b4\ub4dc|\ubcfc\ub9ac\ube44\uc544\ub178|\uac00\ub098 \uad6c\uad8c \uc2dc\ub514|\ubab0\ud0c0 \ub9ac\ub77c|\ud638\uc8fc \ub2ec\ub7ec|\uc774\ud0c8\ub9ac\uc544 \ub9ac\ub77c|\uac00\ub098 \uc2dc\ub514|\uc2f1\uac00\ud3f4 \ub2ec\ub7ec|\ud30c\ub098\ub9c8 \ubc1c\ubcf4\uc544|\ub77c\uc624\uc2a4 \ud0a4\ud504|\ud0a4\ub974\uae30\uc2a4\uc2a4\ud0c4 \uc19c|\uc2a4\uc704\uc2a4 \ud504\ub791\ub2ec\ub7ec|\ud638\uc8fc \uc2e4\ub9c1|\ubbf8\uad6d \ub2ec\ub7ec|\uc774\ub514\uc624\ud53c\uc544 \ub2ec\ub7ec|\ubd80\ub8e8\ub098\uc774 \ub2ec\ub7ec|\uc790\uba54\uc774\uce74 \ud30c\uc6b4\ub4dc|\uc774\ub514\uc624\ud53c\uc544 \ube44\ub974|\uc54c\uc81c\ub9ac \ud504\ub791 \uc81c\ub974\ubbf8\ub0a0|\uc54c\uc81c\ub9ac \uc2e0\uad8c \ud504\ub791|\uc54c\uc81c\ub9ac \ub514\ub098\ub974|\ud30c\ub77c\uacfc\uc774 \uacfc\ub77c\ub2c8|\ub9ac\ube44\uc544 \ud30c\uc6b4\ub4dc|\uc790\uba54\uc774\uce74 \ub2ec\ub7ec|\uc544\uc774\uc2ac\ub780\ub4dc \ud06c\ub85c\ub098|\uc2a4\ud398\uc778 \ud398\uc138\ud0c0|\ubc84\ubba4\ub2e4 \ud30c\uc6b4\ub4dc|\ub9ac\ube44\uc544 \ub514\ub098\ub974|\ub9ac\ube44\uc544 \uc601\uad6d \uad70\uc0ac\ub839 \ub9ac\ub77c|\ubc84\ubba4\ub2e4 \ub2ec\ub7ec|\ub124\ub378\ub780\ub4dc \uae38\ub354|\ubaa8\ub9ac\ud0c0\ub2c8 \uc6b0\uae30\uc57c|\uc774\ub780 \ub9ac\uc584|\uc2a4\uc6e8\ub374 \ud06c\ub85c\ub098|\uc5d0\ub9ac\ud2b8\ub9ac\uc544 \ub098\ud06c\ud30c|\ucf00\ub0d0 \uc2e4\ub9c1|\uc544\ub974\ud5e8\ud2f0\ub098 \ud398\uc18c|\uc544\ub974\ud5e8\ud2f0\ub098 \ud398\uc18c (1983-1985)|\uc544\ub974\ud5e8\ud2f0\ub098 \ud398\uc18c \ubaa8\ub124\ub2e4 \uad6d\uc601|\ub300\ub9cc \uc2e0\uad8c \ub2ec\ub7ec|\uc218\ub2e8 \ud30c\uc6b4\ub4dc|\uadf8\ub8e8\uc9c0\uc57c \ub77c\ub9ac|\uadf8\ub8e8\uc9c0\uc57c \uc9c0\ud3d0 \ub77c\ub9ac\ud2b8|\ub9d0\ud2f0\ub2c8\ud06c \ud504\ub791|\ud3ec\ud074\ub79c\ub4dc\uc81c\ub3c4 \ud30c\uc6b4\ub4dc|\uc544\ub974\ud5e8\ud2f0\ub098 \uc624\uc2a4\ud2b8\ub784|\uc218\ub2e8 \ub514\ub098\ub974|\uc774\ub77c\ud06c \ub514\ub098\ub974|\ud22c\ubc1c\ub8e8 \ub2ec\ub7ec|\uc138\uc774\uc274 \ub8e8\ud53c|\ub77c\ud2b8\ube44\uc544 \ub8e8\ube14|\ud53c\uc9c0 \ud30c\uc6b4\ub4dc|\ub77c\ud2b8\ube44\uc544 \ub77c\ud2b8|\ucf69\uace0 \uc790\uc774\ub974|\ucf69\uace0 \uacf5\ud654\uad6d \ud504\ub791|\ucf69\uace0 \ud504\ub791 \ucf69\uace8\ub77c\uc2a4|\ud53c\uc9c0 \ub2ec\ub7ec|\ub2c8\uce74\ub77c\uacfc \ucf54\ub974\ub3c4\ubc14 \uc624\ub85c|\ub9c8\uce74\uc624 \ud30c\ud0c0\uce74|\ub2c8\uce74\ub77c\uacfc \ucf54\ub974\ub3c4\ubc14|\ud540\ub780\ub4dc \ub9c8\ub974\uce74 (1860-1962)|\ud540\ub780\ub4dc \ub9c8\ub974\uce74|\uc194\ub85c\ubaac \uc81c\ub3c4 \ub2ec\ub7ec|\ub8e9\uc148\ubd80\ub974\ud06c \ud504\ub791|\ud2b8\ub9ac\ub2c8\ub2e4\ub4dc \ud1a0\ubc14\uace0 \uad6c\uad8c \ub2ec\ub7ec|\uc559\uace8\ub77c \uc5d0\uc2a4\ucfe0\ub3c4|\uc559\uace8\ub77c \ucf74\uc790 Reajustado (1995-1999)|\ubabd\uace8 \ud22c\uadf8\ub9ad|\ud5dd\uac00\ub9ac \ud3ec\ub9b0\ud2b8|\ubd80\ub8ec\ub514 \ud504\ub791|\uc559\uace8\ub77c \uc2e0\uadc4 \ucf74\uc790 (1990-2000)|\uc559\uace8\ub77c \ucf74\uc790 (1977-1990)|\ud2b8\ub9ac\ub2c8\ub2e4\ub4dc \ud1a0\ubc14\uace0 \ub2ec\ub7ec|\uc2a4\uc640\uc9c8\ub780\ub4dc \ub9b4\ub791\uac8c\ub2c8|\uc601\uad6d\ub839 \ud30c\uc6b4\ub4dc \uc2a4\ud138\ub9c1|\uc0ac\uc6b0\ub514\uc544\ub77c\ube44\uc544 \uc790\uce58\ub839 \ub9ac\uc584|\uc0ac\uc6b0\ub514\uc544\ub77c\ube44\uc544 \ub9ac\uc584|\ub8e9\uc148\ubd80\ub974\ud06c \ud0c0\ub85c\ub098|\uc778\ub3c4 \ub8e8\ud53c|\ud3ec\ub974\ud22c\uac08 \uc5d0\uc2a4\ucfe0\ub3c4|\uc559\uace8\ub77c \ucf74\uc790|\ud3ec\ub974\ud22c\uac08 \ucf58\ud1a0|\ub9ac\ud22c\uc544\ub2c8\uc544 \ub9ac\ud0c0|\uce74\uc790\ud750\uc2a4\ud0c4 \ud150\uac8c|\uce74\uc790\ud750\uc2a4\ud0c4 \ub8e8\ube14|\uc601\uad6d\ub839 \ubc84\uc9c4 \uc544\uc77c\ub79c\ub4dc \ub2ec\ub7ec|\ub2c8\uc81c\ub974 \ud30c\uc6b4\ub4dc|\ubbf8\uc580\ub9c8 \ub2ec\ub7ec \ud0dc\ud658\uad8c|\ub2c8\uc81c\ub974 \ub098\uc774\ub77c|\ud558\uc774\ud2f0 \uad6c\ub974\ub4dc|\uc2dc\ub9ac\uc544 \ud30c\uc6b4\ub4dc|\ud314\ub808\uc2a4\ud0c0\uc778 \ud30c\uc6b4\ub4dc|\ubc14\ub808\uc778 \ub514\ub098\ub974|\ubbf8\uc580\ub9c8 \ud0a4\uc58f|\ub124\ub378\ub780\ub4dc \uc548\ud2f8\ub808\uc2a4 \uad74\ub374|\uccb4\ucf54 \uacf5\ud654\uad6d \ucf54\ub8e8\ub098|\ub9e8\ub3c4 \ud30c\uc6b4\ub4dc \uc2a4\ud138\ub9c1|\ubd88\uac00\ub9ac\uc544 \ub81b \ud0dc\ud658\uad8c|\ub808\uc18c\ud1a0 \ub85c\ud2f0|\uac00\ubd09 CFA \ud504\ub791|\ubd88\uac00\ub9ac\uc544 \ub81b (1879-1952)|\ubd88\uac00\ub9ac\uc544 \uc2e0\uad8c \ub81b|\ubd88\uac00\ub9ac\uc544 \uc0ac\ud68c\uc8fc\uc758 \ub81b|\uce90\ub098\ub2e4 \ub2ec\ub7ec|\ubd88\uac00\ub9ac\uc544 \ub3d9\uc804 \ub81b|\ud130\uae30 \ub9ac\ub77c|\ucf00\uc774\ub9e8 \uc81c\ub3c4 \ub2ec\ub7ec|\uc2f8\uc774\ud504\ub7ec\uc2a4 \ud30c\uc6b4\ub4dc|\uc774\uc2a4\ub77c\uc5d8 \uc2e0\uad8c \uc138\ucf08|\uac00\uc774\uc544\ub098 \ub2ec\ub7ec|\uc544\ub974\uba54\ub2c8\uc544 \ub4dc\ub78c|\uc774\uc2a4\ub77c\uc5d8 \ud30c\uc6b4\ub4dc|\ub9d0\ub9ac \ud504\ub791|\uc774\uc2a4\ub77c\uc5d8 \uc138\ucf08|\ubca0\ub124\uc8fc\uc5d8\ub77c \ubcfc\ub9ac\ubc14\ub974|\uc54c\ubc14\ub2c8\uc544 \ub2ec\ub7ec \ud0dc\ud658\uad8c|\ub77c\uc774\ubca0\ub9ac\uc544 \ub2ec\ub7ec|\uc54c\ubc14\ub2c8\uc544 \ub808\ud06c \ubc1c\ub8e8\ud2b8|\ud06c\ub85c\uc544\ud2f0\uc544 \ucfe0\ub098|\ub9ac\uc720\ub2c8\uc628 \ud504\ub791|\ud06c\ub85c\uc544\ud2f0\uc544 \ub514\ub098\ub974|\uc54c\ubc14\ub2c8\uc544 \ub808\ud06c|\uc800\uc9c0 \ud30c\uc6b4\ub4dc \uc2a4\ud138\ub9c1|\uc54c\ubc14\ub2c8\uc544 \ub808\ud06c (1946-1961)|\ub9c8\ucf00\ub3c4\ub2c8\uc544 \ub514\ub098\ub974 (1992-1993)|\ubd81 \ubca0\ud2b8\ub0a8 \ubca0\ud2b8\ubbfc \ud53c\uc544\uc2a4\ud0c0 \ub3d9 \ubca0\ud2b8|\ubd81 \ubca0\ud2b8\ub0a8 \uc2e0\uad8c \ub3d9|\ub9c8\ucf00\ub3c4\ub2c8\uc544 \ub514\ub098\ub974|\ubd81 \ubca0\ud2b8\ub0a8 \ud53c\uc544\uc2a4\ud0c0 \ub3d9 \ubca0\ud2b8|\ud2f0\ubaa8\ub974 \ud30c\ud0c0\uce74|\ubca8\uae30\uc5d0 \ud504\ub791 (\uae08\uc735)|\uae30\ub124\ube44\uc3d8 \ud398\uc18c|\ucfe0\uc6e8\uc774\ud2b8 \ub514\ub098\ub974|\ud3ec\ub974\ud22c\uac08\ub839 \uae30\ub2c8 \ubc00 \ub808\uc774\uc2a4|\ubca8\uae30\uc5d0 \ud504\ub791|\ud2f0\ubaa8\ub974 \uc5d0\uc2a4\ucfe0\ub3c4|\ubca8\uae30\uc5d0 \ud504\ub791 (\ud0dc\ud658)|\ud3ec\ub974\ud22c\uac08\ub839 \uae30\ub2c8 \uc5d0\uc2a4\ucfe0\ub3c4|\uc5d8\uc0b4\ubc14\ub3c4\ub974 \ucf5c\ub860|\ucfe0\ub77c\uce74\uc624 \uae38\ub354|\ubc29\uae00\ub77c\ub370\uc2dc \ud0c0\uce74|\ud1b5\uac00 \ud30c\uc6b4\ub4dc \uc2a4\ud138\ub9c1|\uc18c\ub828 \ub8e8\ube14|\uc18c\ub828 \uc2e0\uad8c \ub8e8\ube14|\ub274 \uce7c\ub808\ub3c4\ub2c8\uc544 \ud504\ub791 \uc81c\ub974\ubbf8\ub0a0|\uce74\ubcf4\ubca0\ub974\ub370 \uc5d0\uc2a4\ucfe0\ub3c4|\ub0a8\uc544\ud504\ub9ac\uce74 \ub79c\ub4dc|\ub3c4\ubbf8\ub2c8\uce74 \ud398\uc18c|\ucfe0\ubc14 \ud0dc\ud658\uad8c \ub9c8\ub974\ud06c|\ub0a8\uc544\ud504\ub9ac\uce74 \ud30c\uc6b4\ub4dc|\ub0a8\uc544\ud504\ub9ac\uce74 \ub79c\ub4dc (\uae08\uc735)|\ud280\ub2c8\uc9c0 \ub514\ub098\ub974|\ucfe0\ubc14 \ud398\uc18c|\ud504\ub791\uc2a4\ub839 \uac00\uc774\uc544\ub098 \ud504\ub791 \uae30\uc544\ub098|\uc6b0\uac04\ub2e4 \uc2e4\ub9c1|\uc2e4\ub860 \ub8e8\ud53c|\uc544\ud30c\ub974\uc640 \uc774\uc0ac\uc2a4\uc758 \ud504\ub791|\ubc14\ud2f0\uce78 \ub9ac\ub77c|\uc0c1\ud22c\uba54 \ud504\ub9b0\uc2dc\ud398 \uc5d0\uc2a4\ucfe0\ub3c4|\uc6b0\uac04\ub2e4 \uc2e4\ub9c1 (1966-1987)|\uc0c1\ud22c\uba54 \ud504\ub9b0\uc2dc\ud398 \ub3c4\ube0c\ub77c|\ub9c8\uc0ec \uad70\ub3c4 \ub2ec\ub7ec|\ub274\uc9c8\ub79c\ub4dc \ud30c\uc6b4\ub4dc|\uc11c \uc0ac\ubaa8\uc544 \ud0c8\ub77c|\uc11c \uc0ac\ubaa8\uc544 \ud30c\uc6b4\ub4dc|\uc628\ub450\ub77c\uc2a4 \ub818\ud53c\ub77c|\ud504\ub791\uc2a4 \uba54\ud2b8\ub85c\ud3f4\ub9ac\ud0c4 \ub204\ubcf4 \ud504\ub791|\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4 \ub9c8\ub098\ud2b8|\uacfc\ud14c\ub9d0\ub77c \ucf00\ud2b8\uc0b4|\ub274\uc9c8\ub79c\ub4dc \ub2ec\ub7ec|\uc2a4\ucf54\ud2c0\ub79c\ub4dc \ud30c\uc6b4\ub4dc|\ubc14\ubca0\uc774\ub3c4\uc2a4 \ub2ec\ub7ec|\ub098\ubbf8\ube44\uc544 \ub2ec\ub7ec|\ub9c8\ub2e4\uac00\uc2a4\uce74\ub974 \ud504\ub791|\ub9c8\ub2e4\uac00\uc2a4\uce74\ub974 \uc544\ub9ac\uc544\ub9ac|\uc774\uc9d1\ud2b8 \ud30c\uc6b4\ub4dc|\uc601\uad6d\ub839 \ud63c\ub450\ub77c\uc2a4 \ub2ec\ub7ec|\ud3f4\ub780\ub4dc \uc990\ub85c\ud2f0 (1950-1995)|\ubcf4\uc2a4\ub2c8\uc544-\ud5e4\ub974\uccb4\uace0\ube44\ub098 \uc2e0 \ub514\ub098\ub974|\ubcf4\uc2a4\ub2c8\uc544-\ud5e4\ub974\uccb4\uace0\ube44\ub098 \ud0dc\ud658 \ub9c8\ub974\ud06c|\ubca8\ub9ac\uc988 \ub2ec\ub7ec|\ubcf4\uc2a4\ub2c8\uc544-\ud5e4\ub974\uccb4\uace0\ube44\ub098 \ub514\ub098\ub974|\ud3f4\ub780\ub4dc \uc990\ub85c\ud2f0|\uc608\uba58 \ub9ac\uc54c|\uc218\ub9ac\ub0a8 \uae38\ub354|\uccb4\ucf54\uc2ac\ub85c\ubc14\ud0a4\uc544 \ub3d9\uc804 \ucf54\ub8e8\ub098|\ub300\ud55c\ubbfc\uad6d \uc6d0|\ubca8\ub77c\ub8e8\uc2a4 \ub8e8\ube14|\ubca8\ub77c\ub8e8\uc2a4 \ub8e8\ube14 (1992-1994)|\uccb4\ucf54\uc2ac\ub85c\ubc14\ud0a4\uc544 \ucf54\ub8e8\ub098|\ub300\ud55c\ubbfc\uad6d \uad6c\uad8c \uc6d0|\ub300\ud55c\ubbfc\uad6d \ud658|\ubca8\ub77c\ub8e8\uc2a4 \uc2e0\uad8c \ub8e8\ube14 (1994-1999)|\uc18c\ub9d0\ub9ac\ub79c\ub4dc \uc2e4\ub9c1|\uadf8\ub9ac\uc2a4 \uc2e0\uad8c \ub4dc\ub77c\ud06c\ub9c8|\ud30c\ud0a4\uc2a4\ud0c4 \ub8e8\ud53c|\uc544\ud504\uac00\ub2c8|\uc9d0\ube44\ube0c\uc6e8 \ub2ec\ub7ec|\uc2a4\ub9ac\ub791\uce74 \ub8e8\ud53c|\uadf8\ub9ac\uc2a4 \ub4dc\ub77c\ud06c\ub9c8|\uc544\uc77c\ub79c\ub4dc \ud30c\uc6b4\ub4dc|\uc544\ud504\uac00\ub2c8 (1927-2002)|\uc608\uba58 \ub514\ub098\ub974|\ub974\uc644\ub2e4 \ud504\ub791|\ucf54\uc2a4\ud0c0\ub9ac\uce74 \ucf5c\ub860|\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4 \uc18c\ubaa8\ub2c8|\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4 \ub8e8\ube14|\uc5d0\uc2a4\ud1a0\ub2c8\uc544 \ud06c\ub8ec|\uc801\ub3c4 \uae30\ub2c8 \ud398\uc138\ud0c0 \uae30\ub2c8\uc544\ub098|\ubab0\ub3c4\ubc14 \ub8e8\ube14 \uc9c0\ud3d0|\ud64d\ucf69 \ub2ec\ub7ec|\ub374\ub9c8\ud06c \ud06c\ub85c\ub124|\ubab0\ub3c4\ubc14 \ub808\uc774|\uc801\ub3c4 \uae30\ub2c8 \ud504\ub791|\uc778\ub3c4\ub124\uc2dc\uc544 \ub8e8\ud53c\uc544|\uc544\ub78d\uc5d0\ubbf8\ub808\uc774\ud2b8 \ub514\ub098\ub974|\uc870\uc120 \ubbfc\uc8fc\uc8fc\uc758 \uc778\ubbfc \uacf5\ud654\uad6d \uc6d0|\uc778\ub3c4\ub124\uc2dc\uc544 \uc2e0\uad8c \ub8e8\ud53c\uc544|\ubcf4\uce20\uc640\ub098 \ud3f4\ub77c|\ubab0\ub3c4\ubc14 \ub808\uc774 \uc9c0\ud3d0|\uc778\ub3c4\ub124\uc2dc\uc544 \uc790\ubc14 \ub8e8\ud53c\uc544|\uc870\uc120 \ubbfc\uc8fc\uc8fc\uc758 \uc778\ubbfc \uacf5\ud654\uad6d \uc6d0|\uc778\ub3c4\ub124\uc2dc\uc544 \ub2c8\uce74 \uae38\ub354|\ubc14\ub204\uc544\ud22c \ubc14\ud22c|\uc774\uc2ac\ub78c \ub514\ub098\ub974|\uc18c\ub9d0\ub9ac\uc544 \uc2e4\ub9c1|\uc548\ub3c4\ub77c \ud398\uc138\ud0c0|\ub7ec\uc2dc\uc544 \ub8e8\ube14 (1991-1998)|\uacfc\ub2ec\ub85c\ud504 \ud504\ub791|\uc9c0\ubd80\ud2f0 \ud504\ub791|\uc548\ub3c4\ub77c \ub514\ub124\ub974|\ubaa8\ub098\ucf54 \ud504\ub791 \uc81c\ub974\ubbf8\ub0a0|\ubaa8\ub098\ucf54 \ud504\ub791 \ub204\ubcf4|\uc5d0\ucfe0\uc544\ub3c4\ub974 \uc218\ud06c\ub808|\ub9ac\ud788\ud150\uc288\ud0c0\uc778 \ud504\ub791|\ub7ec\uc2dc\uc544 \ub8e8\ube14|\ud544\ub9ac\ud540 \ud398\uc18c|\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4 \uc228|\ucf5c\ub86c\ube44\uc544 \ud398\uc18c|\ud0dc\uad6d \ubc14\ud2b8|\ubd81\ubd80 \uc544\uc77c\ub79c\ub4dc \ud30c\uc6b4\ub4dc|\ubc84\ub9c8 \ub8e8\ud53c|\ucf69\uace0 CFA \ud504\ub791|\ubc84\ub9c8 \ucc28\ud2b8|\ucf5c\ub86c\ube44\uc544 \uc9c0\ud3d0 \ud398\uc18c|\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4 \uc228 \ucfe0\ud3f0|\uce74\ud0c0\ub974 \ub9ac\uc584|\uc6b0\ud06c\ub77c\uc774\ub098 \uadf8\ub9ac\ube0c\ub098|\uae30\ub2c8 \uc2dc\ub9ac|\uc911\uad6d \uc704\uc548 \uc778\ubbfc\ud3d0|\ubaa8\uc7a0\ube44\ud06c \uba54\ud2f0\uce7c|\uc6b0\ub8e8\uacfc\uc774 \ud398\uc18c \uc6b0\ub8e8\uacfc\uc694|\uae30\ub2c8 \ud504\ub791 (1960-1972)|\uc0b0\ub9c8\ub9ac\ub178 \ub9ac\ub77c|\ubaa8\uc7a0\ube44\ud06c \uc5d0\uc2a4\ucfe0\ub3c4|\ud30c\ud478\uc544\ub274\uae30\ub2c8 \ud0a4\ub098|\uc624\ub9cc \ub9ac\uc584 \uc0ac\uc774\ub514|\uae30\ub2c8 \ud504\ub791|\uc6b0\ub8e8\uacfc\uc774 \ud398\uc18c (1975-1993)|\uc624\ub9cc \ub9ac\uc584|\ud504\ub791\uc2a4 UIC-\ud504\ub791|\uc790\uc774\ub974 \uc790\uc774\ub974|\ubd80\ud0c4 \ub8e8\ud53c|\ubaa8\ub85c\ucf54 \ud504\ub791|\ubaa8\ub85c\ucf54 \ub514\ub818|\ud504\ub791\uc2a4 Gold \ud504\ub791|\ubd80\ud0c4 \ub20c\ud22c\ub214|\uc6b0\ub8e8\uacfc\uc774 \ud398\uc18c \ud478\uc5d0\ub974\ub5bc|\ub9d0\ub808\uc774\uc9c0\uc544 \ub9c1\uae30\ud2b8|\uc790\uc774\ub974 \uc2e0\uad8c \uc790\uc774\ub974|\uc544\uc81c\ub974\ubc14\uc774\uc820 \ub9c8\ub098\ud2b8|\uac10\ube44\uc544 \ud30c\uc6b4\ub4dc|\ucf54\ubaa8\ub974 \ud504\ub791|\uc2dc\uc5d0\ub77c\ub9ac\uc628 \ub9ac\uc628|\uac10\ube44\uc544 \ub2ec\ub77c\uc2dc|\uc720\ub7fd \ud658\uc728 \ub2e8\uc704|\ubc14\ud558\ub9c8 \ub2ec\ub7ec \ud30c\uc6b4\ub4dc|\ubc14\ud558\ub9c8 \ub2ec\ub7ec|\uba55\uc2dc\ucf54 \uc2e4\ubc84 \ud398\uc18c (1861-1992)|\uba55\uc2dc\ucf54 \ud398\uc18c|\ud398\ub8e8 \uc194|\uadf8\ub9b0\ub780\ub4dc \ud06c\ub85c\ub124|\ube0c\ub77c\uc9c8 \ud06c\ub8e8\uc81c\uc774\ub8e8 (1942-1967)|\ud398\ub8e8 \uc194 \ub204\uc5d0\ubcf4|\uce60\ub808 \ud398\uc18c|\uc2ac\ub85c\ubc14\ud0a4\uc544 \ucf54\ub8e8\ub098|\ud398\ub8e8 \uc778\ud2f0|\ube0c\ub77c\uc9c8 \ud06c\ub8e8\uc81c\uc774\ub8e8|\ud2b9\ubcc4\uc778\ucd9c\uad8c|\ud504\ub791\uc2a4 \ud504\ub791 \uc81c\ub974\ubbf8\ub0a0/\ud504\ub791 \ud3ec\uc559\uce74\ub808|\ud504\ub791\uc2a4 \ud504\ub791|\ube0c\ub77c\uc9c8 \ud06c\ub8e8\uc790\ub450 \ub178\ubcf4|\uce60\ub808 \uc5d0\uc2a4\ucfe0\ub3c4|\ube0c\ub77c\uc9c8 \ub808\uc54c|\uce60\ub808 \ucf58\ub3c4\ub974|\ube0c\ub77c\uc9c8 \ud06c\ub8e8\uc81c\uc774\ub8e8 (1990-1993)|\ub3c5\uc77c \uc2a4\ud37c\ub9c8\ub974\ud06c|\ub9d0\ub77c\uc704 \ud30c\uc6b4\ub4dc|\ube0c\ub77c\uc9c8 \ud06c\ub8e8\uc790\ub450|\ubcfc\ub9ac\ube44\uc544\ub178  \ud06c\ub8e8\uc81c\uc774\ub8e8 \ub178\ubcf4 (1967-1986)|\ub9d0\ub77c\uc704 \ucf70\uccd0|\ub3c5\uc77c \ub9c8\ub974\ud06c|\ub124\ud314 \ub8e8\ud53c|\ucfe1 \uc81c\ub3c4 \ub2ec\ub7ec|\uc77c\ubcf8 \uc5d4\ud654|\ubab0\ub514\ube0c \uc81c\ub3c4 \ub8e8\ud53c\uc544|\ubab0\ub514\ube0c \uc81c\ub3c4 \ub8e8\ud53c|\ub3d9\uce74\ub9ac\ube0c \ub2ec\ub7ec|\uc2ac\ub85c\ubca0\ub2c8\uc544 \ud1a8\ub77c\ub974|\uc720\uace0\uc2ac\ub77c\ube44\uc544 \uac1c\ub7c9 \ub514\ub098\ub974|\uc544\ub8e8\ubc14 \uae38\ub354|\uc720\uace0\uc2ac\ub77c\ube44\uc544 10\uc6d4 \ub514\ub098\ub974|\ub3d9\ub3c5 \uc624\uc2a4\ud2b8\ub9c8\ub974\ud06c|\uc720\uace0\uc2ac\ub77c\ube44\uc544 \uc804\ud658 \ub514\ub098\ub974|\uc720\uace0\uc2ac\ub77c\ube44\uc544 \ub178\ube44 \ub514\ub098\ub974|\ud130\ud06c\uc2a4\ucf00\uc774\ucee4\uc2a4 \ud06c\ub77c\uc6b4|\uc720\uace0\uc2ac\ub77c\ube44\uc544 1994 \ub514\ub098\ub974|\uc720\uace0\uc2ac\ub77c\ube44\uc544 \uc5f0\ud569 \ub514\ub098\ub974|\ub8e8\ub9c8\ub2c8\uc544 \uc2e0\uad8c \ub808\uc774|\uc720\uace0\uc2ac\ub77c\ube44\uc544 \ub3d9\uc804 \ub514\ub098\ub974|\ub8e8\ub9c8\ub2c8\uc544 \ub808\uc774|\uc2ac\ub85c\ubca0\ub2c8\uc544 \ud1a8\ub77c\ub974 \ubcf8\uc2a4|\ub178\ub974\uc6e8\uc774 \ud06c\ub85c\ub124|\ubaa8\ub9ac\uc154\uc2a4 \ub8e8\ud53c|\uc9c0\ube0c\ub864\ud130 \ud30c\uc6b4\ub4dc|\ubca0\ud2b8\ub0a8 \uad6d\uc601 \ub3d9|\ubca0\ud2b8\ub0a8 \uacf5\ud654\uad6d \ub3d9|\ud0a4\ub9ac\ubc14\uc2dc \ub2ec\ub7ec|\uc138\uc778\ud2b8\ud5ec\ub808\ub098 \ud30c\uc6b4\ub4dc|\ubca0\ud2b8\ub0a8 \uc2e0\uad8c \ub3d9";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|ITL|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIC|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|SUR|SUN|NCF|CVE|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|QAR|UAH|GNS|CNY|MZM|UYU|GNI|SML|MZE|PGK|OMS|GNF|UYP|OMR|XFU|ZRZ|BTR|MAF|MAD|XFO|BTN|UYF|ZRN|MYR|AZM|GMP|KMF|SLL|GMD|XEU|BSP|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|DEM|NPR|CKD|JPY|MVR|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|GIP|VNS|VNR|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JOD|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|ITL|GHC|SGD|PAB|LAK|KGS|CHF|ATS|US$|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|UM|IRR|SEK|ERN|KES|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIC|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|SUR|SUN|NCF|CVE|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|BAM|BZD|BAD|PLN|YER|SRG|CSK|\uffe6|BYR|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IR\u00a3|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|QAR|UAH|GNS|CNY|MZM|UYU|GNI|SML|MZE|PGK|OMS|GNF|UYP|OMR|XFU|ZRZ|BTR|MAF|MAD|XFO|BTN|UYF|ZRN|MYR|AZM|GMP|KMF|SLL|GMD|XEU|BSP|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|DEM|NPR|CKD|\uffe5|MVR|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|GIP|VNS|VNR|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "1\uc6d4",
    "2\uc6d4",
    "3\uc6d4",
    "4\uc6d4",
    "5\uc6d4",
    "6\uc6d4",
    "7\uc6d4",
    "8\uc6d4",
    "9\uc6d4",
    "10\uc6d4",
    "11\uc6d4",
    "12\uc6d4",
    null,
  };

  private static final String[] months = {
    "1\uc6d4",
    "2\uc6d4",
    "3\uc6d4",
    "4\uc6d4",
    "5\uc6d4",
    "6\uc6d4",
    "7\uc6d4",
    "8\uc6d4",
    "9\uc6d4",
    "10\uc6d4",
    "11\uc6d4",
    "12\uc6d4",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\uc77c",
    "\uc6d4",
    "\ud654",
    "\uc218",
    "\ubaa9",
    "\uae08",
    "\ud1a0",
  };

  private static final String[] weekdays = {
    null,
    "\uc77c\uc694\uc77c",
    "\uc6d4\uc694\uc77c",
    "\ud654\uc694\uc77c",
    "\uc218\uc694\uc77c",
    "\ubaa9\uc694\uc77c",
    "\uae08\uc694\uc77c",
    "\ud1a0\uc694\uc77c",
  };

  private static final String[] eras = {
    "\uae30\uc6d0\uc804",
    "\uc11c\uae30",
  };

  private static final String[] ampms = {
    "\uc624\uc804",
    "\uc624\ud6c4",
  };

  private static final String[][] zoneStrings =
  {
    { "PST", "\ud0dc\ud3c9\uc591 \ud45c\uc900\uc2dc", "PDT", "\ud0dc\ud3c9\uc591 \uae30\uc900\uc2dc",  "America/Los_Angeles" },
    { "HST", "\ud558\uc640\uc774 \ud45c\uc900\uc2dc", "HST", "\ud558\uc640\uc774 \ud45c\uc900\uc2dc",  "Pacific/Honolulu" },
    { "GMT", "\uadf8\ub9ac\ub2c8\uce58 \ud45c\uc900\uc2dc", "GMT", "\uadf8\ub9ac\ub2c8\uce58 \ud45c\uc900\uc2dc",  "Etc/GMT" },
    { "MST", "\uc0b0\uc545 \ud45c\uc900\uc2dc", "MST", "\uc0b0\uc545 \ud45c\uc900\uc2dc",  "America/Phoenix" },
    { "GMT", "\uadf8\ub9ac\ub2c8\uce58 \ud45c\uc900\uc2dc", "GMT", "\uadf8\ub9ac\ub2c8\uce58 \ud45c\uc900\uc2dc",  "Africa/Casablanca" },
    { "MST", "\uc0b0\uc545 \ud45c\uc900\uc2dc", "MDT", "\uc0b0\uc545 \uae30\uc900\uc2dc",  "America/Denver" },
    { "IST", "\uc774\uc2a4\ub77c\uc5d8 \ud45c\uc900\uc2dc", "IDT", "\uc774\uc2a4\ub77c\uc5d8 \uae30\uc900\uc2dc",  "Asia/Jerusalem" },
    { "AST", "\uc54c\ub798\uc2a4\uce74 \ud45c\uc900\uc2dc", "ADT", "\uc54c\ub798\uc2a4\uce74 \uae30\uc900\uc2dc",  "America/Anchorage" },
    { "CET", "\uc911\ubd80\uc720\ub7fd \ud45c\uc900\uc2dc", "CEST", "\uc911\ubd80\uc720\ub7fd \uae30\uc900\uc2dc",  "Europe/Paris" },
    { "EST", "\ub3d9\ubd80 \ud45c\uc900\uc2dc", "EST", "\ub3d9\ubd80 \ud45c\uc900\uc2dc",  "America/Indianapolis" },
    { "EET", "\ub3d9\ubd80\uc720\ub7fd \ud45c\uc900\uc2dc", "EEST", "\ub3d9\ubd80\uc720\ub7fd \uae30\uc900\uc2dc",  "Europe/Bucharest" },
    { "JST", "\uc77c\ubcf8 \ud45c\uc900\uc2dc", "JST", "\uc77c\ubcf8 \ud45c\uc900\uc2dc",  "Asia/Tokyo" },
    { "CTT", "\uc911\uad6d \ud45c\uc900\uc2dc", "CDT", "\uc911\uad6d \ud45c\uc900\uc2dc",  "Asia/Shanghai" },
    { "EST", "\ub3d9\ubd80 \ud45c\uc900\uc2dc", "EDT", "\ub3d9\ubd80 \uae30\uc900\uc2dc",  "America/New_York" },
    { "KST", "\ud55c\uad6d\ud45c\uc900\uc2dc", "KST", "\ud55c\uad6d\ud45c\uc900\uc2dc",  "Asia/Seoul" },
    { "AST", "\ub300\uc11c\uc591 \ud45c\uc900\uc2dc", "ADT", "\ub300\uc11c\uc591 \uae30\uc900\uc2dc",  "America/Halifax" },
    { "CNT", "\ub274\ud380\ub4e4\ub79c\ub4dc \ud45c\uc900\uc2dc", "CDT", "\ub274\ud380\ub4e4\ub79c\ub4dc \uae30\uc900\uc2dc",  "America/St_Johns" },
    { "CST", "\uc911\ubd80 \ud45c\uc900\uc2dc", "CDT", "\uc911\ubd80 \uae30\uc900\uc2dc",  "America/Chicago" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "\ub3d9\ud2f0\ubaa8\ub974|\ud1a0\ucf08\ub77c\uc6b0|\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4|\ud0dc\uad6d|\ud1a0\uace0|\ud504\ub791\uc2a4 \ub0a8\ubd80 \uc9c0\ubc29|\uac00\uc774\uc544\ub098|\ucc28\ub4dc|\ud130\ud06c\uc2a4\ucf00\uc774\ucee4\uc2a4\uc81c\ub3c4|\uae30\ub124\ube44\uc3d8|\uad0c|\uacfc\ud14c\ub9d0\ub77c|\uc0ac\uc6b0\uc2a4\uc870\uc9c0\uc544-\uc0ac\uc6b0\uc2a4\uc0cc\ub4dc\uc704\uce58\uc81c\ub3c4|\uadf8\ub9ac\uc2a4|\uc801\ub3c4 \uae30\ub2c8|\uacfc\ub2ec\ub85c\ud504|\uc2a4\uc640\uc9c8\ub79c\ub4dc|\uc2dc\ub9ac\uc544|\uae30\ub2c8|\uac10\ube44\uc544|\uadf8\ub9b0\ub780\ub4dc|\uc5d8\uc0b4\ubc14\ub3c4\ub974|\uc0c1\ud22c\uba54 \ud504\ub9b0\uc2dc\ud398|\uc9c0\ube0c\ub864\ud130|\uac00\ub098|\uc218\ub9ac\ub0a8|\ud504\ub791\uc2a4\ub839 \uae30\uc544\ub098|\uc138\ub974\ube44\uc544|\uadf8\ub8e8\uc9c0\uc57c|\uc18c\ub9d0\ub9ac\uc544|\uadf8\ub808\ub098\ub2e4|\uc138\ub124\uac08|\uc0b0\ub9c8\ub9ac\ub178|\uc601\uad6d|\uc2dc\uc5d0\ub77c\ub9ac\uc628|\uac00\ubd09|\uc2ac\ub85c\ubc14\ud0a4\uc544|\uc2a4\ubc1c\ubc14\ub974\uc81c\ub3c4-\uc580\ub9c8\uc6ec\uc12c|\uc2ac\ub85c\ubca0\ub2c8\uc544|\uc138\uc778\ud2b8\ud5ec\ub808\ub098|\uc2f1\uac00\ud3ec\ub974|\uc2a4\uc6e8\ub374|\uc218\ub2e8|\uc250\uc774\uc258|\uc194\ub85c\ubaac|\uc0ac\uc6b0\ub514\uc544\ub77c\ube44\uc544|\ud504\ub791\uc2a4|\ud398\ub85c\uc81c\ub3c4|\ub9c8\uc774\ud06c\ub85c\ub124\uc2dc\uc544|\ub974\uc644\ub2e4|\ud3ec\ud074\ub79c\ub4dc\uc81c\ub3c4|\ub7ec\uc2dc\uc544|\ud53c\uc9c0|\ud540\ub780\ub4dc|\ub8e8\ub9c8\ub2c8\uc544|\ub9ac\uc720\ub2c8\uc628|\uc774\ub514\uc624\ud53c\uc544|\uc2a4\ud398\uc778|\uc5d0\ub9ac\ud2b8\ub9ac\uc544|\uc11c\uc0ac\ud558\ub77c|\uc774\uc9d1\ud2b8|\uc5d0\uc2a4\ud1a0\ub2c8\uc544|\uc5d0\ucfe0\uc544\ub3c4\ub974|\uc54c\uc81c\ub9ac|\uce74\ud0c0\ub974|\ub3c4\ubbf8\ub2c8\uce74 \uacf5\ud654\uad6d|\ud30c\ub77c\uacfc\uc774|\ub3c4\ubbf8\ub2c8\uce74|\ud314\ub77c\uc6b0|\ub374\ub9c8\ud06c|\uc9c0\ubd80\ud2f0|\ud3ec\ub974\ud2b8\uce7c|\ud314\ub808\uc2a4\ud0c0\uc778 \uc9c0\uad6c|\ud478\uc5d0\ub974\ud1a0\ub9ac\ucf54|\ub3c5\uc77c|\ud54f\ucf00\uc5b8\uc12c|\uc138\uc778\ud2b8\ud53c\uc5d0\ub974-\ubbf8\ucf00\ub871|\ud3f4\ub780\ub4dc|\ud30c\ud0a4\uc2a4\ud0c4|\ud544\ub9ac\ud540|\ud30c\ud478\uc544\ub274\uae30\ub2c8|\ud504\ub791\uc2a4\ub839 \ud3f4\ub9ac\ub124\uc2dc\uc544|\uccb4\ucf54|\ud398\ub8e8|\uc0ac\uc774\ud504\ub7ec\uc2a4|\ud06c\ub9ac\uc2a4\ub9c8\uc2a4\uc12c|\uae4c\ubf40\ubca0\ub974\ub370|\ud30c\ub098\ub9c8|\ucfe0\ubc14|\ucf54\uc2a4\ud0c0\ub9ac\uce74|\ucf5c\ub86c\ube44\uc544|\uc911\uad6d|\uce74\uba54\ub8ec|\uce60\ub808|\ucfe1\uc81c\ub3c4|\ucf54\ud2b8\ub514\ubd80\uc640\ub974|\uc2a4\uc704\uc2a4|\ucf69\uace0|\uc911\uc559 \uc544\ud504\ub9ac\uce74|\ucf69\uace0\ubbfc\uc8fc\uacf5\ud654\uad6d|\ucf54\ucf54\uc2a4\uc81c\ub3c4|\uc624\ub9cc|\uce90\ub098\ub2e4|\ubca8\ub9ac\uc988|\ubca8\ub77c\ub8e8\uc2a4|\ubcf4\uce20\uc640\ub098|\ubd80\ubca0|\ubd80\ud0c4|\ubc14\ud558\ub9c8|\ube0c\ub77c\uc9c8|\ub274\uc9c8\ub79c\ub4dc|\ubcfc\ub9ac\ube44\uc544|\ube0c\ub8e8\ub098\uc774|\ubc84\ubba4\ub2e4|\ub2c8\uc6b0\uc5d0|\ubca0\ub139|\ubd80\ub8ec\ub514|\ubc14\ub808\uc778|\ub098\uc6b0\ub8e8|\ubd88\uac00\ub9ac\uc544|\ubd80\ub974\ud0a4\ub098\ud30c\uc18c|\ub124\ud314|\ubca8\uae30\uc5d0|\ub178\ub974\uc6e8\uc774|\ubc29\uae00\ub77c\ub370\uc2dc|\ubc14\ubca0\uc774\ub3c4\uc2a4|\uc9d0\ubc14\ube0c\uc6e8|\ub124\ub35c\ub780\ub4dc|\ubcf4\uc2a4\ub2c8\uc544 \ud5e4\ub974\uccb4\uace0\ube44\ub098|\ub2c8\uce74\ub77c\uacfc|\ub098\uc774\uc9c0\ub9ac\uc544|\ub178\ud37d\uc12c|\uc544\uc81c\ub974\ubc14\uc774\uc794|\ub2c8\uc81c\ub974|\ub274 \uce7c\ub808\ub3c4\ub2c8\uc544|\uc544\ub8e8\ubc14|\uc7a0\ube44\uc544|\ub098\ubbf8\ube44\uc544|\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544|\uc624\uc2a4\ud2b8\ub9ac\uc544|\uc544\uba54\ub9ac\uce78 \uc0ac\ubaa8\uc544|\uc544\ub974\ud5e8\ud2f0\ub098|\ub0a8\uadf9 \ub300\ub959|\ubaa8\uc7a0\ube44\ud06c|\uc559\uace8\ub77c|\ub9d0\ub808\uc774\uc9c0\uc544|\ub124\ub35c\ub780\ub4dc\ub839 \uc548\ud2f8\ub808\uc2a4|\uba55\uc2dc\ucf54|\uc544\ub974\uba54\ub2c8\uc544|\ub9d0\ub77c\uc704|\uc54c\ubc14\ub2c8\uc544|\ubab0\ub514\ube0c|\ub0a8\uc544\ud504\ub9ac\uce74|\ubaa8\ub9ac\uc154\uc2a4|\ubab0\ud0c0|\uc548\uae38\ub77c|\ubaac\ud2b8\uc138\ub77c\ud2b8|\ubaa8\ub9ac\ud0c0\ub2c8|\uc564\ud2f0\uac00 \ubc14\ubd80\ub2e4|\ub9d0\ud2f0\ub2c8\ud06c|\uc544\ud504\uac00\ub2c8\uc2a4\ud0c4|\ubd81\ub9c8\ub9ac\uc544\ub098\uc81c\ub3c4|\uc544\ub78d\uc5d0\ubbf8\ub9ac\ud2b8|\ub9c8\uce74\uc624, \uc911\uad6d \ud2b9\ubcc4\ud589\uc815\uad6c|\uc548\ub3c4\ub77c|\ubabd\uace8|\ubbf8\uc580\ub9c8|\ub9d0\ub9ac|\ub9c8\ucf00\ub3c4\ub2c8\uc544\uc5b4|\uc720\uace0\uc2ac\ub77c\ube44\uc544|\ub9c8\uc694\ud2f0|\ub9c8\uc0ec \uad70\ub3c4|\ub9c8\ub2e4\uac00\uc2a4\uce74\ub974|\ubab0\ub3c4\ubc14|\ubaa8\ub098\ucf54|\ubaa8\ub85c\ucf54|\uc608\uba58|\ub9ac\ube44\uc544|\ub77c\ud2b8\ube44\uc544|\ub8e9\uc148\ubd80\ub974\ud06c|\ub9ac\ud22c\uc544\ub2c8\uc544|\ub808\uc18c\ud1a0|\ub77c\uc774\ubca0\ub9ac\uc544|\uc2a4\ub9ac\ub791\uce74|\ub9ac\ud788\ud150\uc288\ud0c0\uc778|\uc138\uc778\ud2b8\ub8e8\uc2dc\uc544|\ub808\ubc14\ub17c|\ub77c\uc624\uc2a4|\uce74\uc790\ud750\uc2a4\ud0c4|\ucf00\uc774\ub9e8\uc81c\ub3c4|\ucfe0\uc6e8\uc774\ud2b8|\ub300\ud55c\ubbfc\uad6d|\uc870\uc120 \ubbfc\uc8fc\uc8fc\uc758 \uc778\ubbfc \uacf5\ud654\uad6d|\uc138\uc778\ud2b8\ud06c\ub9ac\uc2a4\ud1a0\ud37c \ub124\ube44\uc2a4|\ucf54\ubaa8\ub974|\ud0a4\ub9ac\ubc14\uc2dc|\uc0ac\ubaa8\uc544|\uce84\ubcf4\ub514\uc544|\ud0a4\ub974\uae30\uc2a4\uc2a4\ud0c4|\ucf00\ub0d0|\uc648\ub9ac\uc2a4-\ud478\ud22c\ub098 \uc81c\ub3c4|\uc77c\ubcf8|\uc694\ub974\ub2e8|\uc790\uba54\uc774\uce74|\ubc14\ub204\uc544\ud22c|\ubca0\ud2b8\ub0a8|\ubbf8\uad6d\ub839 \ubc84\uc9c4 \uc544\uc77c\ub79c\ub4dc|\uc601\uad6d\ub839 \ubc84\uc9c4 \uc544\uc77c\ub79c\ub4dc|\ubca0\ub124\uc218\uc5d8\ub77c|\uc138\uc778\ud2b8\ube48\uc13c\ud2b8\uadf8\ub808\ub098\ub518|\ubc14\ud2f0\uce78|\uc774\ud0c8\ub9ac\uc544|\uc544\uc774\uc2ac\ub780\ub4dc|\uc774\ub780|\uc774\ub77c\ud06c|\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4|\uc601\uad6d\ub839\uc778\ub3c4\uc591\uc2dd\ubbfc\uc9c0|\uc6b0\ub8e8\uacfc\uc774|\uc778\ub3c4|\uc774\uc2a4\ub77c\uc5d8|\ubbf8\uad6d|\uc544\uc77c\ub79c\ub4dc|\uc778\ub3c4\ub124\uc2dc\uc544|\ubbf8\uad6d\ub839 \ud574\uc678 \uc81c\ub3c4|\uc6b0\uac04\ub2e4|\uc6b0\ud06c\ub77c\uc774\ub098|\ud5dd\uac00\ub9ac|\ud558\uc774\ud2f0|\ud06c\ub85c\uc544\ud2f0\uc544|\ud0c4\uc790\ub2c8\uc544|\uc628\ub450\ub77c\uc2a4|\ud5c8\ub4dc\uc12c-\ub9e5\ub3c4\ub110\ub4dc\uc81c\ub3c4|\ub300\ub9cc|\ud22c\ubc1c\ub8e8|\ud64d\ucf69, \uc911\uad6d \ud2b9\ubcc4\ud589\uc815\uad6c|\ud2b8\ub9ac\ub2c8\ub2e4\ub4dc \ud1a0\ubc14\uace0|\ud130\ud0a4|\ud1b5\uac00|\ud280\ub2c8\uc9c0|\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|akk|eka|ijo|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|kut|mic|wa|kum|zap|cus|jbo|doi|vo|oto|vi|vai|rar|ve|rap|raj|ota|nzi|nap|uz|uga|tmh|nai|nah|ur|fat|uk|egy|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|bal|ty|bai|tw|srr|tli|tt|ts|bad|tr|to|tn|tl|tk|ti|th|kru|tg|byn|te|kro|csb|ta|tkl|efi|sw|sv|su|krc|st|ss|sr|sq|men|crp|so|afh|sn|sm|sl|grc|sk|grb|si|sh|crh|afa|sg|se|sd|udm|sc|sa|rw|ru|mdr|ro|rn|rm|mdf|tiv|ady|zun|kpe|qu|tig|son|cpp|sog|ada|kos|hit|cpf|cpe|him|kok|hil|got|gor|gon|din|nub|pt|ps|fur|phn|goh|snk|cop|yap|ach|yao|phi|pl|ace|pi|pa|bug|iba|sms|bua|mas|smn|os|map|or|man|smj|smi|mak|om|mai|oj|mag|mad|sma|oc|nso|btk|myv|dgr|ny|myn|nv|kmb|nr|gmh|no|nn|nl|ng|sla|ne|nd|cmc|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mh|mg|mwr|bra|den|lv|lu|del|lt|lo|ln|li|ewo|lg|lb|la|jpr|vot|sit|ky|kw|kv|ku|sio|ks|kr|awa|ko|kn|km|kl|kk|rom|kj|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|jv|gil|znd|shn|fon|xal|aus|kho|ja|khi|pau|chy|tai|iu|pap|it|sgn|is|kha|chr|pam|pal|chp|io|cho|chn|chm|tyv|bnt|pag|ik|chk|ii|haw|lam|ig|chg|sga|paa|ie|id|lah|day|chb|ia|lad|hai|dar|hy|ath|hu|ht|dak|hr|ho|hi|dyu|he|ast|ha|wen|gv|gu|sem|sel|iro|gn|gl|arw|gez|art|gd|ira|ga|arp|arn|fy|bla|gem|ypk|arc|fr|fo|cel|fj|fi|ff|tvl|ceb|fa|eu|sco|et|es|eo|en|el|tut|niu|tup|ee|tum|mos|dz|nic|lus|fiu|dv|nia|moh|luo|lun|apa|lui|hup|bin|de|lua|bik|was|und|war|da|dum|wal|mno|wak|sat|cy|sas|kbd|cv|cu|mni|cs|sam|cr|sal|dua|co|sai|mnc|sah|kaw|inh|gba|sad|ch|ine|bho|enm|kar|inc|gay|ca|umb|syr|kam|tsi|ang|kac|cau|kab|kaa|bs|car|br|bo|bn|bm|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|hsb|az|ay|av|as|dsb|ar|ilo|elx|zh|an|pra|am|new|ak|za|af|ab|aa|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "\uadf8\uc704\uce5c\uc5b4|\uc544\uce74\ub4dc\uc5b4|\uc774\uce74\uc8fd\uc5b4|\uc774\uc870\uc5b4|\ubc18\ud22c\uc5b4(\ub0a8\uc544\ud504\ub9ac\uce74)|\uc218\uba54\ub974\uc5b4|\uc218\uc218\uc5b4|\uae30\ud0c0 \uc5b8\uc5b4|\ub85c\uc9c0\uc5b4|\ud1b5\uac00\uc5b4 (\ub2c8\uc544\uc0b4\ub79c\ub4dc)|\ud3fc\ud398\uc774\uc5b4|\ubbf8\ub0ad\uce74\ubc14\uc6b0|\uc218\ucfe0\ub9c8\uc871\uc5b4|\uc62c\ub85c\ud504\uc5b4|\ubabd\uad6c\uc5b4|\ucfe0\ud14c\ub124\uc5b4|\ubbf8\ud06c\ub9e5\uc5b4|\uc648\ub860\uc5b4|\ucfe0\ubbf9\uc5b4|\uc0ac\ud3ec\ud14c\ud06c\uc5b4|\ucfe0\uc2dc\ud2b8\uc81c\uc871\uc5b4 (\uae30\ud0c0)|\ub85c\ubc18\uc5b4|\ub3c4\uadf8\ub9ac\uc5b4|\ubcfc\ub77c\ud4cc\ud06c\uc5b4|\uc624\ud1a0\ubbf8\uc548\uc5b4|\ubca0\ud2b8\ub0a8\uc5b4|\ubc14\uc774\uc5b4|\ud30c\ub85c\ud1a4\uac04\uc5b4|\ubca4\ub2e4\uc5b4|\ub77c\ud30c\ub274\uc774|\ub77c\uc790\uc2a4\ud0c4\uc5b4|\ud130\ud0a4\uc5b4, \uc624\uc2a4\ub9cc (1500-1928)|\ub290\uc9c0\ub9c8\uc5b4|\ub098\ud3f4\ub9ac\uc5b4|\uc6b0\uc988\ubca0\ud06c\uc5b4|\uc720\uac00\ub9ac\ud2f1\uc5b4|\ud0c0\ub9c8\uc139\uc5b4|\ubd81 \uc544\uba54\ub9ac\uce78 \uc778\ub514\uc5b8\uc5b4 (\uae30\ud0c0)|\ub098\uc6b0\uc544\ud2c0\uc5b4|\uc6b0\ub974\ub450\uc5b4|\ud310\ud2f0\uc5b4|\uc6b0\ud06c\ub77c\uc774\ub098\uc5b4|\uc774\uc9d1\ud2b8\uc5b4 (\uace0\ub300)|\uc704\uad6c\ub974\uc5b4|\ud321\uadf8\uc5b4|\ub2c8\ub85c-\uc0ac\ud558\ub78c\uc5b4 (\uae30\ud0c0)|\uc544\uc77c\ub79c\ub4dc\uc5b4, \uc911\uc138 (900-1200)|\ubc1c\ud2b8\uc5b4 (\uae30\ud0c0)|\ub274\ub85c\uc5b4|\ubc14\uc0ac\uc5b4|\ub2c8\uc548\ucf5c\uc5b4|\ub2c8\uc554\uc6e8\uc9c0\uc5b4|\ud788\ubab8\uc5b4|\ubc1c\ub9ac\uc5b4|\uc624\uc138\uc774\uc9c0\uc5b4|\ubc1c\ub8e8\uce58\uc5b4|\ud0c0\ud788\ud2f0\uc5b4|\ubc14\ubbf8\ub808\ucf00\uc5b4|\ud2b8\uc704\uc5b4|\uc138\uc140\uc5b4|\ud2c0\ub9c1\uae43\uc871\uc5b4|\ud0c0\ud0c0\ub974\uc5b4|\ud1b5\uac00\uc5b4|\ubc18\ub2e4\uc5b4|\ud130\ud0a4\uc5b4|\ud1b5\uac00\uc5b4|\uc138\uce20\uc640\ub098\uc5b4|\ud0c0\uac08\ub85c\uadf8\uc5b4|\ud22c\ub974\ud06c\uba58\uc5b4|\ud2f0\uadf8\ub9ac\ub0d0\uc5b4|\ud0dc\uad6d\uc5b4|\ucfe0\ub974\ud06c\uc5b4|\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4\uc5b4|\ube0c\ub9b0\uc5b4|\ud154\ub8e8\uad6c\uc5b4|\ud06c\ub8e8\uc5b4|\uce74\uc288\ube44\uc544\uc5b4|\ud0c0\ubc00\uc5b4|\ud1a0\ucf08\ub77c\uc6b0\uc81c\ub3c4\uc5b4|\uc774\ud53d\uc5b4|\uc2a4\uc640\ud790\ub9ac\uc5b4|\uc2a4\uc6e8\ub374\uc5b4|\uc21c\ub2e8\uc5b4|\uce74\ub77c\ucc60\uc774-\ubc1c\uce74\ub974\uc5b4|\uc138\uc18c\ud1a0\uc5b4|\uc2dc\uc2a4\uc640\ud2f0\uc5b4|\uc138\ub974\ube44\uc544\uc5b4|\uc54c\ubc14\ub2c8\uc544\uc5b4|\uba58\ub370\uc5b4|\ud06c\ub808\uc624\uc2a4\uc640 \ud53c\uae34\uc2a4\uc5b4 (\uae30\ud0c0)|\uc18c\ub9d0\ub9ac\uc544\uc5b4|\uc544\ud504\ub9ac\ud788\ub9ac\uc5b4|\uc1fc\ub098\uc5b4|\uc0ac\ubaa8\uc544\uc5b4|\uc2ac\ub85c\ubca0\ub2c8\uc544\uc5b4|\uadf8\ub9ac\uc2a4\uc5b4, \uace0\ub300 (1453\ub144 \uae4c\uc9c0)|\uc2ac\ub85c\ubc14\ud0a4\uc544\uc5b4|\uac8c\ub974\ubcf4\uc5b4|\uc2a4\ub9ac\ub791\uce74\uc5b4|\uc138\ub974\ubcf4\ud06c\ub85c\uc544\ud2f0\uc544\uc5b4|\ud06c\ub9ac\ubbfc \ud130\ud0a4\uc5b4; \ud06c\ub9ac\ubbfc \ud0c0\ud0c0\ub974\uc5b4|\uc544\uc2dc\uc544-\uc544\ud504\ub9ac\uce74\uc5b4 (\uae30\ud0c0)|\uc0b0\uace0\uc5b4|\ubd81\ubd80 \uc0ac\ubbf8\uc5b4|\uc2e0\ub514\uc5b4|\uc6b0\ub4dc\ub9d0\ud2b8\uc5b4|\uc0ac\ub974\ub514\ub2c8\uc544\uc5b4|\uc0b0\uc2a4\ud06c\ub9ac\ud2b8\uc5b4|\ubc18\ud22c\uc5b4(\ub8e8\uc644\ub2e4)|\ub7ec\uc2dc\uc544\uc5b4|\ub9cc\ub2e4\ub974\uc5b4|\ub8e8\ub9c8\ub2c8\uc544\uc5b4|\ubc18\ud22c\uc5b4(\ubd80\ub8ec\ub514)|\ub808\ud1a0\ub85c\ub9cc\uc5b4|\ubaa8\ud06c\uc0e4\uc5b4|\ud2f0\ube44\uc5b4|\uc544\ub2e5\ud5e4\uc5b4|\uc8fc\ub2c8\uc5b4|\ucf54\ud3a0\ub808|\ucf00\ucd94\uc544\uc5b4|\ud2f0\uadf8\ub808\uc5b4|\uc1a1\uac00\uc774\uc871\uc5b4|\ud06c\ub808\uc624\ub9ac\uc2a4\uc640 \ud53c\uae34\uc2a4\uc5b4, \ud3ec\ub974\ud22c\uac08\uc5b4-\uae30\ubc18 (\uae30\ud0c0)|\uc18c\uadf8\ub514\uc5d4\uc5b4|\uc544\ub2f9\uba54\uc5b4|\ucf54\uc2a4\ub77c\uc774\uc5d4\uc5b4|\ud558\ud0c0\uc774\ud2b8\uc5b4|\ud06c\ub808\uc624\ub9ac\uc2a4\uc640 \ud53c\uae34\uc2a4\uc5b4, \ud504\ub791\uc2a4\uc5b4-\uae30\ubc18 (\uae30\ud0c0)|\ud06c\ub808\uc624\ub9ac\uc2a4\uc640 \ud53c\uae34\uc2a4\uc5b4, \uc601\uc5b4-\uae30\ubc18 (\uae30\ud0c0)|\ud788\ub9c8\ucc28\ub9ac\uc5b4|\ucf54\uce74\ub2c8\uc5b4|\ud5e4\ub9ac\uac00\ub1ec\uc5b4|\uace0\ud2b8\uc5b4|\uace0\ub860\ud0c8\ub85c\uc5b4|\uace4\ub514\uc5b4|\ub529\uce74\uc5b4|\ub204\ube44\uc548\uc5b4|\ud3ec\ub974\ud22c\uce7c\uc5b4|\ud30c\uc2dc\ud1a0\uc5b4 (\ud478\uc2dc\ud1a0)|\ud504\ub9ac\uc6b0\ub9ac\uc548\uc5b4|\ud398\ub2c8\ud0a4\uc544\uc5b4|\ub3c5\uc77c\uc5b4, \uace0\ub300 \uc800\uae09 (ca.750-1050)|\uc18c\ub2cc\ucf00\uc5b4|\ucf65\ud2b8\uc5b4|\uc58d\ud398\uc138\uc5b4|\uc544\ucf5c\ub9ac\uc5b4|\uc57c\uc624\uc871\uc5b4|\ud544\ub9ac\ud540\uc5b4 (\uae30\ud0c0)|\ud3f4\ub780\ub4dc\uc5b4|\uc544\uccb4\uc5b4|\ud314\ub9ac\uc5b4|\ud380\uc7a1\uc5b4|\ubd80\uae30\uc5b4|\uc774\ubc18\uc5b4|\uc2a4\ucf5c\ud2b8 \uc0ac\ubbf8\uc5b4|\ubd80\ub9ac\uc544\ud0c0|\ub9c8\uc0ac\uc774\uc5b4|\uc774\ub098\ub9ac \uc0ac\ubbf8\uc5b4|\uc624\uc138\ud2b8\uc5b4|\ub0a8\ub3c4\uc5b4|\uc624\ub9ac\uc57c\uc5b4|\ub9cc\ub529\uace0\uc5b4|\ub8f0\ub808 \uc0ac\ubbf8\uc5b4|\uc0ac\ubbf8\uc5b4 (\uae30\ud0c0)|\ub9c8\uce74\uc0ac\uc5b4|\uc624\ub85c\ubaa8\uc5b4 (\uc544\ud310)|\ub9c8\uc774\ud2f8\ub9ac|\uc624\uc9c0\ube0c\uc6e8\uc774\uc5b4|\ub9c8\uac00\ud788|\ub9c8\ub450\ub808\uc138|\ub0a8\ubd80 \uc0ac\ubbf8\uc5b4|\uc625\uc2dc\ud2b8\uc5b4|\uc18c\ud1a0\uc5b4, \ubd81\ubd80|\ubc14\ud0c0\ud06c\uc5b4|\uc5d8\uc988\uc57c\uc5b4|\ub3c4\uadf8\ub9ac\ube0c\uc5b4|\ub2c8\uc548\uc790\uc5b4; \uce58\uce04\uc5b4; \uce04\uc5b4|\ub9c8\uc57c\uc5b4|\ub098\ubc14\ud638\uc5b4|\ud0b4\ubd84\ub204\uc5b4|\uc740\ub370\ubca8\ub808\uc5b4, \ub0a8\ubd80|\ub3c5\uc77c\uc5b4, \uc911\uc138 \uace0\uae09 (ca.1050-1500)|\ub178\ub974\uc6e8\uc774\uc5b4|\ub258\ub178\ub974\uc2a4\ud06c \ub178\ub974\uc6e8\uc774\uc5b4|\ub124\ub35c\ub780\ub4dc\uc5b4|\ub290\ub3d9\uac00\uc5b4|\uc2ac\ub77c\ube0c\uc5b4 (\uae30\ud0c0)|\ub124\ud314\uc5b4|\uc740\ub370\ubca8\ub808\uc5b4, \ubd81\ubd80|\uce74\ubbf9\uc5b4|\ud14c\ud23c\uc5b4|\ubcf4\ud06c\ub9d0 \ub178\ub974\uc6e8\uc774\uc5b4|\ub098\uc6b0\ub8e8\uc5b4|\ud14c\ub808\ub178\uc5b4|\ud300\ub2c8\uc5b4|\ubc84\ub9c8\uc5b4|\ub808\uc988\uae30\uc548\uc5b4|\ubab0\ud0c0\uc5b4|\ud398\ub974\uc2dc\uc548 \uace0\ub300\uc5b4 (ca.600-400 B.C.)|\ub9d0\ub808\uc774\uc5b4|\ub9c8\ub77c\ud2f0\uc5b4|\ud504\ub791\uc2a4\uc5b4, \uace0\ub300 (842-ca.1400)|\ubab0\ub2e4\ube44\uc544\uc5b4|\ud504\ub791\uc2a4\uc5b4, \uc911\uc138 (ca.1400-1600)|\ubabd\uace8\uc5b4|\uc720\ub300-\uc544\ub77c\ube44\uc544\uc5b4|\ub9d0\ub77c\uc584\ub78c\uc5b4|\ub9c8\ucf00\ub3c4\ub2c8\uc544\uc5b4|\ub9c8\uc624\ub9ac\uc5b4|\ub9c8\uc15c\uc81c\ub3c4\uc5b4|\ub9c8\ub2e4\uac00\uc2a4\uce74\ub974\uc5b4|\ub9c8\ub974\uc640\ub9ac\uc5b4|\ube0c\ub77c\uc5b4|\uc2ac\ub77c\ube0c\uc5b4|\ub77c\ud2b8\ube44\uc544\uc5b4|\ub8e8\ubc14-\uce74\ud0c4\uac00\uc5b4|\ub378\ub77c\uc6e8\uc5b4\uc5b4|\ub9ac\ud22c\uc544\ub2c8\uc544\uc5b4|\ub77c\uc624\uc5b4|\ub9c1\uac08\ub77c\uc5b4|\ub9bc\ubc84\uac70\uc5b4|\uc774\uc6d0\ub3c4\uc5b4|\uac04\ub2e4\uc5b4|\ub8e9\uc148\ubd80\ub974\ud06c\uc5b4|\ub77c\ud2f4\uc5b4|\uc720\ub300-\ud398\ub974\uc2dc\uc544\uc5b4|\ubcf4\ud2f1\uc5b4|\uc778\ub3c4\uc81c\uc5b8\uc5b4 (\uae30\ud0c0)|\ud0a4\ub974\uae30\uc2a4\uc5b4|\ucf58\uc6d4\uc5b4|\ucf54\ubbf8\uc5b4|\ud06c\ub974\ub4dc\uc5b4|\uc218\uc871\uc5b4|\uce74\uc288\ubbf8\ub974\uc5b4|\uce78\ub204\ub9ac\uc5b4|\uc544\uc640\ud788\uc5b4|\ud55c\uad6d\uc5b4|\uce74\ub098\ub2e4\uc5b4|\uce84\ubcf4\ub514\uc544\uc5b4|\uadf8\ub9b0\ub79c\ub4dc\uc5b4|\uce74\uc790\ud750\uc5b4|\uc9d1\uc2dc\uc5b4|\ucfe0\uc548\uc57c\ub9c8\uc5b4|\uc2dc\ub2e4\ubaa8\uc5b4|\ud0a4\ucfe0\uc720\uc5b4|\ucf69\uace0\uc5b4|\ub178\ub974\uc6e8\uc774, \uace0\ub300|\uadf8\ub8e8\uc9c0\uc57c\uc5b4|\ud06c\ub9ac\ud06c\uc5b4|\ub85c\ub9dd\uc2a4\uc5b4 (\uae30\ud0c0)|\ub178\uac00\uc774\uc5b4|\ubb38\ub2e4\uc5b4|\ub2e4\uc911 \uc5b8\uc5b4|\uc790\ubc14\uc5b4|\ud0a4\ub9ac\ubc14\uc2dc\uc5b4|\uc544\uc794\ub370\uc871\uc5b4|\uc0e8\uc5b4|\ud3f0\uc5b4|\uce7c\ubbf8\ud06c\uc5b4|\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544\uc5b4|\ucf54\ud0c4\uc2a4\uc5b4|\uc77c\ubcf8\uc5b4|\ucf54\uc774\uc0b0\uc5b4 (\uae30\ud0c0)|\ud30c\ub77c\uc6b0\uc548\uc5b4|\uc0e4\uc774\uc5d4\uc5b4|\ud0dc\uad6d\uc5b4 (\uae30\ud0c0)|\uc774\ub205\ud2f0\ud22c\ud2b8\uc5b4|\ud30c\ud53c\uc544\uba3c\ud1a0\uc5b4|\uc774\ud0c8\ub9ac\uc544\uc5b4|\uc218\ud654|\uc544\uc774\uc2ac\ub780\ub4dc\uc5b4|\uce74\uc2dc\uc5b4|\uccb4\ub85c\ud0a4\uc5b4|\ud31c\ud321\uac00\uc5b4|\ud314\ube4c\ub808\uc5b4|\uce58\ud398\uc6b0\uc580|\uc774\ub3c4\uc5b4|\ucd09\ud1a0\uc5b4|\uce58\ub204\ud06c\uc5b4\uc640 \uc601\uc5b4 \ud504\ub791\uc2a4\uc5b4\uc758 \ud63c\uc131\uc5b4|\ub9c8\ub9ac\uc5b4|\ud22c\ube44\ub2c8\uc548\uc5b4|\ubc18\ud22c\uc5b4|\ud310\uac00\uc2dc\ub09c\uc5b4|\uc774\ub204\ud53c\uc544\ud06c\uc5b4|\uce04\ucf00\uc2a4\uc5b4|\uc2dc\uce04\uc548 \uc774\uc5b4|\ud558\uc640\uc774\uc5b4|\ub78c\ubc14\uc5b4|\uc774\uadf8\ubcf4\uc5b4|\ucc28\uac00\ud0c0\uc774\uc5b4|\uc544\uc77c\ub79c\ub4dc, \uace0\ub300 (900\ub144 \uae4c\uc9c0)|\ud30c\ud478\uc544\uc5b4 (\uae30\ud0c0)|\uc778\ud130\ub9c1\uac8c\uc5b4|\uc778\ub3c4\ub124\uc2dc\uc544\uc5b4|\ub77c\ud55c\ub2e4\uc5b4|\ub2e4\uc57c\ud06c\uc5b4|\uce58\ube0c\ucc28\uc5b4|\uc778\ud130\ub9c1\uac70|\ub77c\ub514\ub178\uc5b4|\ud558\uc774\ub2e4\uc5b4|\ub2e4\ub974\uadf8\uc640\uc5b4|\uc544\ub974\uba54\ub2c8\uc544\uc5b4|\uc544\ud0c0\ubc14\uc2a4\uce74\uc5b4|\ud5dd\uac00\ub9ac\uc5b4|\uc544\uc774\ud2f0\uc5b4|\ub2e4\ucf54\ud0c0\uc5b4|\ud06c\ub85c\uc544\ud2f0\uc544\uc5b4|\ud788\ub9ac \ubaa8\ud22c\uc5b4|\ud78c\ub514\uc5b4|\ub4dc\uc728\ub77c\uc5b4|\ud788\ube0c\ub9ac\uc5b4|\uc544\uc2a4\ud22c\ub9ac\uc544\uc5b4|\ud558\uc6b0\uc790\uc5b4|\uc18c\ub974\ube0c\uc5b4|\ub9f9\ud06c\uc2a4\uc5b4|\uad6c\uc790\ub77c\ud2b8\uc5b4|\uc148\uc5b4 (\uae30\ud0c0)|\uc140\ucfe0\ud504\uc5b4|\uc774\ub7ec\ucffc\uc774\uc5b4|\uad6c\uc544\ub77c\ub2c8\uc5b4|\uac08\ub9ac\uc2dc\uc544\uc5b4|\uc544\ub77c\uc640\ud06c\uc5b4|\uac8c\uc774\uc988\uc5b4|\uae30\uacc4\uc5b4 (\uae30\ud0c0)|\uc2a4\ucf54\uac24\ub9ad\uc5b4|\uc774\ub780\uc5b4|\uc544\uc77c\ub79c\ub4dc\uc5b4|\uc544\ub77c\ud30c\ud638\uc5b4|\uc544\ub77c\uc6b0\uce78\uc5b4|\ud504\ub9ac\uc9c0\uc544\uc5b4|\uc2dd\uc2dc\uce74\uc5b4|\ub3c5\uc77c\uc5b4 (\uae30\ud0c0)|\uc57c\ud53d\uc5b4|\uc544\ub78c\uc5b4|\ud504\ub791\uc2a4\uc5b4|\ud398\ub85c\uc2a4\uc5b4|\ucf08\ud2b8\uc5b4 (\uae30\ud0c0)|\ud53c\uc9c0\uc5b4|\ud540\ub780\ub4dc\uc5b4|\ud480\ub77c\uc5b4|\ud22c\ubc1c\ub8e8\uc5b4|\uc138\ubd80\uc544\ub178\uc5b4|\uc774\ub780\uc5b4|\ubc14\uc2a4\ud06c\uc5b4|\uc2a4\ucf54\ud2c0\ub79c\ub4dc\uc5b4|\uc5d0\uc2a4\ud1a0\ub2c8\uc544\uc5b4|\uc2a4\ud398\uc778\uc5b4|\uc5d0\uc2a4\ud398\ub780\ud1a0\uc5b4|\uc601\uc5b4|\uadf8\ub9ac\uc2a4\uc5b4|\uc54c\ud0c0\uc774\uc5b4 (\uae30\ud0c0)|\ub2c8\uc6e8\uc5b8\uc5b4|\ud22c\ud53c\uc5b4|\uc5d0\uc6e8\uc5b4|\ud23c\ubd80\uce74\uc5b4|\ubaa8\uc2dc\uc5b4|\ubd80\ud0c4\uc5b4|\ub2c8\uc81c\ub974 - \ucf54\ub974\ub3c4\ud30c\ub2c8\uc544\uc5b4 (\uae30\ud0c0)|\ub8e8\uc0e4\uc774\uc5b4|\ud53c\ub178\uc6b0\uadf8\ub9ac\uc544\uc5b4 (\uae30\ud0c0)|\ub514\ubca0\ud788\uc5b4|\ub2c8\uc544\uc2a4\uc5b4|\ubaa8\ud638\ud06c\uc5b4|\ub8e8\uc624\uc5b4|\ub8ec\ub2e4\uc5b4|\uc544\ud30c\uce58\uc5b4|\ub8e8\uc774\uc138\ub178\uc5b4|\ud6c4\ud30c\uc5b4|\ube44\ub2c8\uc5b4|\ub3c5\uc77c\uc5b4|\ub8e8\ubc14-\ub8f0\ub8e8\uc544\uc5b4|\ube44\ucf5c\uc5b4|\uc640\uc1fc\uc5b4|\uacb0\uc815\ub418\uc9c0\uc54a\uc74c|\uc640\ub77c\uc774\uc5b4|\ub374\ub9c8\ud06c\uc5b4|\ub124\ub35c\ub780\ub4dc, \uc911\uc138 (ca. 1050-1350)|\uc640\ub77c\ubaa8\uc5b4|\ub9c8\ub178\ubcf4\uc5b4|\uc640\uce74\uc0e8\uc5b4|\uc0b0\ud0c8\ub9ac\uc5b4|\uc6e8\uc77c\uc2a4\uc5b4|\uc0ac\uc0ac\ud06c\uc5b4|\uce74\ubc14\ub974\ub514\uc5b4|\ucd94\ubc14\uc2dc\uc5b4|\uad50\ud68c\uc2ac\ub77c\ube0c\uc5b4|\ub9c8\ub2c8\ud478\ub9ac\uc5b4|\uccb4\ucf54\uc5b4|\uc0ac\ub9c8\ub9ac\uc544 \uc544\ub78d\uc5b4|\ud06c\ub9ac\uc5b4|\uc0d0\ub9ac\uc2dc\uc5b4\uc5b4|\ub4dc\uc640\ub77c\uc5b4|\ucf54\ub974\uc2dc\uce74\uc5b4|\ub0a8\uc544\uba54\ub9ac\uce74 \uc778\ub514\uc5b8\uc5b4 (\uae30\ud0c0)|\ub9cc\uc8fc\uc5b4|\uc57c\ud050\ud2b8\uc5b4|\uce74\uc704\uc5b4|\uc778\uadc0\uc2dc\uc5b4|\uadf8\ubc14\uc57c\uc5b4|\uc0b0\ub2e4\uc6e8\uc5b4|\ucc28\ubaa8\ub85c\uc5b4|\uc778\ub3c4\uc720\ub7fd\uc5b4 (\uae30\ud0c0)|\ud638\uc988\ud478\ub9ac\uc5b4|\uc601\uc5b4, \uc911\uc138 (1100-1500)|\uce74\ub80c\uc5b4|\uc778\ub3c4\uc5b4 (\uae30\ud0c0)|\uac00\uc694\uc5b4|\uce74\ud0c8\ub85c\ub2c8\uc544\uc5b4|\uc724\ubc88\ub450\uc5b4|\uc2dc\ub9ac\uc544\uc5b4|\uce84\ubc14\uc5b4|\ud2b8\uc2ec\uc2dc\uc548\uc5b4|\uc774\uc804 \uc601\uc5b4 (ca.450-1100)|\uce74\uce5c\uc5b4|\uce74\ud504\uce74\uc2a4\uc5b4 (\uae30\ud0c0)|\ucee4\ubc14\uc77c\uc5b4|\uce74\ub77c\uce7c\ud30c\ud06c\uc5b4|\ubcf4\uc2a4\ub2c8\uc544\uc5b4|\uce74\ub9ac\ube0c\uc5b4|\ube0c\ub974\ud0c0\ub274\uc5b4|\ud2f0\ubca0\ud2b8\uc5b4|\ubcb5\uace8\uc5b4|\ubc24\ubc14\ub77c\uc5b4|\uac00\uc5b4|\uc911\uc559 \uc544\uba54\ub9ac\uce74 \uc778\ub514\uc548\uc5b4 (\uae30\ud0c0)|\ube44\uc2ac\ub77c\ub9c8\uc5b4|\ube44\ud558\ub974\uc5b4|\ubd88\uac00\ub9ac\uc544\uc5b4|\ubca8\ub85c\ub8e8\uc2dc\uc5b4|\uce74\ub3c4\uc5b4|\ubc14\uc288\ud0a4\ub974\uc5b4|\uc904\ub8e8\uc5b4|\uc81c\ub098\uac00\uc5b4|\ud504\ub85c\ubca4\uce7c\uc5b4, \uace0\ub300 (1500\ub144 \uae4c\uc9c0)|\uc704 \uc18c\ub974\ube44\uc548\uc5b4|\uc544\uc81c\ub974\ubc14\uc774\uc794\uc5b4|\uc544\uc774\ub9c8\ub77c\uc5b4|\uc544\ubc14\ub9ad\uc5b4|\uc544\uc0d8\uc5b4|\uc800\uae09 \uc18c\ub974\ube44\uc548\uc5b4|\uc544\ub78d\uc5b4|\uc774\ub85c\ucf54\uc5b4|\uc5d8\ub78c\uc5b4|\uc911\uad6d\uc5b4|\uc544\ub77c\uace4\uc5b4|\ud504\ub77c\ud06c\ub9ac\ud2b8\uc5b4|\uc554\ud558\ub77c\uc5b4|\ub124\uc640\ub9ac\uc5b4|\uc544\uce78\uc5b4|\uc8fc\uc559\uc5b4|\ub0a8\uc544\uacf5 \uacf5\uc6a9\uc5b4|\uc555\uce74\uc988\uc5b4|\uc544\ud30c\ub974\uc5b4|\uc694\ub8e8\ubc14\uc5b4|\uc54c\ucf58\ud0a8\uc5b4|\uc54c\ub958\ud2b8\uc5b4|\ubaac\ud06c\uba54\ub974\uc5b4 (\uae30\ud0c0)|\uc774\ub514\uc2dc\uc5b4|\ub4dc\ub77c\ube44\ub2e4\uc5b4 (\uae30\ud0c0)|\ubca0\ub974\ubca0\ub974\uc5b4|\uc800\uae09 \ub3c5\uc77c\uc5b4; \uc800\uae09 \uc0c9\uc2a8\uc5b4|\ubcb0\ubc14\uc5b4|\ubca0\uc790\uc5b4|\ud1a0\ud06c \ud53c\uc2e0\uc5b4";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final String variantsKeys = "REVISED";

  private static final String variantsValues = "\uac1c\uc815";

  private static final Hashtable variants;
  static
  {
    variants = new Hashtable();
    Enumeration keys = new StringTokenizer(variantsKeys, "|");
    Enumeration values = new StringTokenizer(variantsValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         variants.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "yy-MM-dd" },
    { "mediumDateFormat", "yyyy-MM-dd" },
    { "longDateFormat", "yyyy'\ub144' M'\uc6d4' d'\uc77c' EE" },
    { "fullDateFormat", "yyyy'\ub144' M'\uc6d4' d'\uc77c' EEEE" },
    { "shortTimeFormat", "a hh'\uc2dc' mm'\ubd84'" },
    { "mediumTimeFormat", "a hh'\uc2dc' mm'\ubd84'" },
    { "longTimeFormat", "a hh'\uc2dc' mm'\ubd84' ss'\ucd08'" },
    { "fullTimeFormat", "a hh'\uc2dc' mm'\ubd84' ss'\ucd08' z" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
    { "variants", variants },
  };

  public Object[][] getContents() { return contents; }
}
